﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.Collections.Generic

Public Class MainForm

#Region "1. 运算符重载"

    Private Sub JoinStringsButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles JoinStringsButton.Click
        '用于存储自定义字符串对象的变量。
        ' ** 转到 ValidatedString.vb 文件中的定义**
        Dim vsA, vsB, vsResult As ValidatedString

        '初始化对象。
        vsA = New ValidatedString(Me.vsATextBox.Text)
        vsB = New ValidatedString(Me.vsBTextBox.Text)

        '使用熟悉的 & 运算符连接或串联自定义对象。
        '** 转到 ValidatedString.vb 文件中的定义**
        vsResult = vsA & vsB

        '显示连接的结果。
        Me.vsResultTextbox.Text = vsResult.Value
    End Sub
#End Region

#Region "2. 泛型使用"

    ''' <remarks>泛型列表为 ValidatedString 参数提供 Intellisense 和编译时检查</remarks>
    Private Sub FillListboxButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles FillListboxButton.Click

        '将 ValidatedString 类型作为参数传递给泛型 List 容器。
        Dim vsList As New List(Of ValidatedString)

        For i As Integer = 0 To 25
            '请注意，ValidatedString 具有 Intellisense 和类型检查功能。
            Dim newValidatedString As ValidatedString
            newValidatedString = New ValidatedString("ListItem") & New ValidatedString(CStr(i))

            If newValidatedString.IsValid = True Then
                '请注意，Add 方法只接受 ValidatedString 类型。
                '尝试添加无效的类型（如整数）。
                vsList.Add(newValidatedString)
            End If
        Next

        '数据绑定了解如何使用泛型列表。
        Me.ListBox1.DataSource = vsList

    End Sub
#End Region

#Region "3. 泛型创建"

    Private Sub pairMatchButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles pairMatchButton.Click
        '用于存储类型字符串值对的变量。
        '尝试将类型参数从 String 更改为其他类型，如 Integer。
        '** 转到 Pair.vb 中的 Pair 泛型类的定义**'
        Dim pair1 As New Pair(Of String, String)
        Dim pair2 As New Pair(Of String, String)

        pair1.FirstValue = Me.pair1aTextBox.Text
        pair1.SecondValue = Me.pair1bTextBox.Text

        pair2.FirstValue = Me.pair2aTextbox.Text
        pair2.SecondValue = Me.pair2bTextbox.Text

        '** 转到 Pair.vb 中 Pair.Matches 泛型类方法的定义**'
        If pair1.Matches(pair2) Then
            Me.pairResultTextbox.Text = "Yes"
        Else
            Me.pairResultTextbox.Text = "No"
        End If
    End Sub

#End Region

#Region "4. Using 语句"
    Private Sub RequestWebStreamButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RequestWebStreamButton.Click

        Dim htmlText As String = ""
        Dim wclient As New System.Net.WebClient

        '在此 Using 块中创建一个流对象，并在末尾释放
        '释放系统资源、连接和流是一个好主意
        '从 Web 请求的结果分配 s 流
        Using s As System.IO.Stream = wclient.OpenRead("http://www.microsoft.com/")
            Dim sReader As New System.IO.StreamReader(s)
            htmlText = sReader.ReadToEnd()
        End Using

        Me.webStreamTextbox.Text = htmlText

    End Sub

#End Region

#Region "5. TryCast 和 IsNot"

    ''' <remarks>使用 ID 和值初始化 TreeView 控件</remarks>
    Private Sub LoadValuesButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles LoadValuesButton.Click
        Dim root, node1, node2 As TreeNode

        '根节点有值但没有 ID。
        root = Me.TreeView1.Nodes.Add("Root")

        'node1 和 node2 包含值和 ID
        'ID 存储在 Tag 属性中，允许按 ID 查找
        node1 = root.Nodes.Add("Value1")
        node1.Tag = "1"

        node2 = root.Nodes.Add("Value2")
        node2.Tag = "2"

        root.Expand()

    End Sub

    ''' <remarks>显示选定节点的值和 ID</remarks>
    Private Sub TreeView1_AfterSelect(ByVal sender As System.Object, ByVal e As System.Windows.Forms.TreeViewEventArgs) Handles TreeView1.AfterSelect

        Dim selectedID As String

        '**尝试将 Tag 对象转换为字符串
        '如果转换成功，selectedID 将具有一个有效值；
        '否则 TryCast 将返回 Nothing
        selectedID = TryCast(e.Node.Tag, String)

        '**使用 IsNot 运算符测试 selectedID 是否为 null
        If selectedID IsNot Nothing Then
            Me.SelectedIDTextbox.Text = selectedID
        Else
            Me.SelectedIDTextbox.Text = "[Nothing]"
        End If

        Me.SelectedValueTextbox.Text = e.Node.Text
    End Sub

#End Region

    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class
